#property copyright "InstaForex"
#property link      "http://www.instaforex.com/"
// ----
#property strict
#property indicator_chart_window
#property indicator_buffers 3
#property indicator_color1 clrGreen
#property indicator_color2 clrGreen
#property indicator_color3 clrGreen
#property indicator_width1 2
#property indicator_width2 2
#property indicator_width3 2

input double Percent = 2.0;
input bool ShowChannel = True;

// ---- buffers
double ExtMapBuffer1[];
double ExtMapBuffer2[];
double ExtMapBuffer3[];

double PREV = 0;

// +------------------------------------------------------------------+
// | Custom indicator initialization function                         |
// +------------------------------------------------------------------+
int init()
{
	// ---- indicators
	SetIndexStyle(0, DRAW_LINE);
	SetIndexBuffer(0, ExtMapBuffer1);
	SetIndexStyle(1, DRAW_LINE);
	SetIndexBuffer(1, ExtMapBuffer2);
	SetIndexStyle(2, DRAW_LINE);
	SetIndexBuffer(2, ExtMapBuffer3);

	PREV = 0; // Close[0];
	// ----
	return (0);
}

// +------------------------------------------------------------------+
// | Custom indicator deinitialization function                       |
// +------------------------------------------------------------------+
int deinit()
{
	// ----

	// ----
	return (0);
}

// +------------------------------------------------------------------+
// | Custom indicator iteration function                              |
// +------------------------------------------------------------------+
int start()
{
	int counted_bars = IndicatorCounted();
	int i;
	double var1;

	int t = Bars - counted_bars;
	if (t > 1)
	{
		t = Bars - 3;
	}

	// ----

	var1 = Percent / 100;

	for (i = t-2; i >= 2; i--)
	{

		if ((Close[i+2] * (1 - var1)) > PREV)
		{
			ExtMapBuffer1[i] = Close[i+2] * (1 - var1);
		}
		else
		{
			if ((Close[i+2] * (1 + var1)) < PREV)
			{
				ExtMapBuffer1[i] = Close[i+2] * (1 + var1);
			}
			else
			{
				ExtMapBuffer1[i] = PREV;
			}
		}
		PREV = ExtMapBuffer1[i];

		if (ShowChannel == True)
		{
			ExtMapBuffer2[i] = ExtMapBuffer1[i] + (ExtMapBuffer1[i] / 100) * Percent;
			ExtMapBuffer3[i] = ExtMapBuffer1[i] - (ExtMapBuffer1[i] / 100) * Percent;
		}
	}

	return (0);
}
// +------------------------------------------------------------------+